import Foundation

func createOrder() {
    let url = URL(string: "https://pay.imb.org.in/api/create-order")!
    var request = URLRequest(url: url)
    request.httpMethod = "POST"
    
    let orderId = Int.random(in: 123456789...999999999)
    let token = "542a08bc000ceb2570dca59993610565" // Replace with your API token
    
    let parameters: [String: Any] = [
        "customer_mobile": "1234567890",
        "user_token": token,
        "amount": "2",
        "order_id": orderId,
        "redirect_url": "https://your_Redirect_URL.in/",
        "remark1": "Customer-email@gmail.com",
        "remark2": "Additional data here"
    ]
    
    request.setValue("application/x-www-form-urlencoded", forHTTPHeaderField: "Content-Type")
    request.httpBody = parameters.map { "\($0.key)=\($0.value)" }
        .joined(separator: "&")
        .data(using: .utf8)
    
    let task = URLSession.shared.dataTask(with: request) { data, response, error in
        guard let data = data, error == nil else {
            print("Request failed: \(error?.localizedDescription ?? "No data")")
            return
        }
        
        if let jsonResponse = try? JSONSerialization.jsonObject(with: data, options: []) as? [String: Any],
           let paymentUrl = jsonResponse["result"] as? [String: Any],
           let url = paymentUrl["payment_url"] as? String {
            print("Redirect to Payment URL: \(url)")
        } else {
            print("Failed to parse response.")
        }
    }
    
    task.resume()
}

// Call the function
createOrder()
