using System;
using System.Net.Http;
using System.Threading.Tasks;
using System.Collections.Generic;

class Program
{
    private static async Task Main(string[] args)
    {
        string url = "https://pay.imb.org.in/api/check-order-status";
        string token = "2048f66bef68633fa3262d7a398ab577"; // Your API token
        string orderId = "9876543210"; // Replace with the actual order ID

        var data = new Dictionary<string, string>
        {
            { "user_token", token },
            { "order_id", orderId }
        };

        using (var client = new HttpClient())
        {
            var content = new FormUrlEncodedContent(data);
            HttpResponseMessage response = await client.PostAsync(url, content);

            if (response.IsSuccessStatusCode)
            {
                string result = await response.Content.ReadAsStringAsync();
                dynamic jsonResponse = Newtonsoft.Json.JsonConvert.DeserializeObject(result);

                if (jsonResponse.status == "COMPLETED")
                {
                    Console.WriteLine("Transaction Status: " + jsonResponse.result.txnStatus);
                    Console.WriteLine("Message: " + jsonResponse.message);
                    Console.WriteLine("Order ID: " + jsonResponse.result.orderId);
                    Console.WriteLine("Amount: " + jsonResponse.result.amount);
                    Console.WriteLine("Date: " + jsonResponse.result.date);
                    Console.WriteLine("UTR: " + jsonResponse.result.utr);
                }
                else
                {
                    Console.WriteLine("Error: " + jsonResponse.message);
                }
            }
            else
            {
                Console.WriteLine("Error with API request");
            }
        }
    }
}
