using System;
using System.Net.Http;
using System.Threading.Tasks;
using System.Collections.Generic;
using System.Net.Http.Headers;

class Program
{
    private static async Task Main(string[] args)
    {
        string url = "https://pay.imb.org.in/api/create-order";
        string token = "542a08bc000ceb2570dca59993610565"; // Enter your API token here
        string orderId = new Random().Next(123456789, 999999999).ToString(); // Create your unique order ID

        var data = new Dictionary<string, string>
        {
            { "customer_mobile", "1234567890" }, // Your customer phone number
            { "user_token", token },
            { "amount", "2" },
            { "order_id", orderId },
            { "redirect_url", "https://your_Redirect_URL.in/" },
            { "remark1", "Customer-email@gmail.com" },
            { "remark2", "You can send any of your data" }
        };

        using (var client = new HttpClient())
        {
            var content = new FormUrlEncodedContent(data);
            HttpResponseMessage response = await client.PostAsync(url, content);

            if (response.IsSuccessStatusCode)
            {
                string result = await response.Content.ReadAsStringAsync();
                dynamic jsonResponse = Newtonsoft.Json.JsonConvert.DeserializeObject(result);

                if (jsonResponse != null)
                {
                    string paymentUrl = jsonResponse.result.payment_url;
                    Console.WriteLine("Redirect to: " + paymentUrl);
                }
            }
            else
            {
                Console.WriteLine("There is a problem with the API or parameters.");
            }
        }
    }
}
