var GarudHub = {
    open: function(paymentUrl) {
        if (document.getElementById('garud-overlay')) return;

        var overlay = document.createElement('div');
        overlay.id = 'garud-overlay';
        overlay.style.cssText = 'position:fixed;top:0;left:0;width:100%;height:100%;background:rgba(0,0,0,0.7);z-index:9999999;display:flex;justify-content:center;align-items:center;backdrop-filter:blur(5px);';

        var iframe = document.createElement('iframe');
        iframe.src = paymentUrl;
        // Size wahi rakha hai taaki aapka page mobile view jaisa perfect dikhe
        iframe.style.cssText = 'width:400px;height:700px;max-width:100%;max-height:100%;border:none;border-radius:15px;background:#fff;box-shadow:0 10px 30px rgba(0,0,0,0.5);';

        if (window.innerWidth < 450) {
            iframe.style.borderRadius = '0';
            iframe.style.width = '100%';
            iframe.style.height = '100%';
        }

        overlay.appendChild(iframe);
        document.body.appendChild(overlay);
        this.overlay = overlay;
    },
    close: function() {
        var el = document.getElementById('garud-overlay');
        if (el) el.remove();
    }
};

window.addEventListener('message', function(event) {
    if (event.data.action === 'garud_payment_complete') {
        GarudHub.close();
        window.location.href = event.data.redirect_url;
    }
});