import okhttp3.*;
import com.google.gson.Gson;
import java.io.IOException;

public class CheckOrderStatus {

    private static final String API_URL = "https://pay.imb.org.in/api/check-order-status";
    private static final String API_TOKEN = "2048f66bef68633fa3262d7a398ab577"; // Replace with your API token

    public static void main(String[] args) {
        checkOrderStatus("9876543210"); // Replace with the actual order ID
    }

    private static void checkOrderStatus(String orderId) {
        StatusRequest statusRequest = new StatusRequest(API_TOKEN, orderId);
        Gson gson = new Gson();
        String json = gson.toJson(statusRequest);

        RequestBody body = RequestBody.create(json, MediaType.parse("application/json"));
        Request request = new Request.Builder()
                .url(API_URL)
                .post(body)
                .build();

        OkHttpClient client = new OkHttpClient();
        client.newCall(request).enqueue(new Callback() {
            @Override
            public void onFailure(Call call, IOException e) {
                System.out.println("Request failed: " + e.getMessage());
            }

            @Override
            public void onResponse(Call call, Response response) throws IOException {
                if (response.isSuccessful()) {
                    String responseData = response.body().string();
                    StatusResponse statusResponse = gson.fromJson(responseData, StatusResponse.class);
                    if ("COMPLETED".equals(statusResponse.getStatus())) {
                        System.out.println("Transaction Status: " + statusResponse.getResult().getTxnStatus());
                        System.out.println("Order ID: " + statusResponse.getResult().getOrderId());
                        System.out.println("Amount: " + statusResponse.getResult().getAmount());
                        System.out.println("Date: " + statusResponse.getResult().getDate());
                        System.out.println("UTR: " + statusResponse.getResult().getUtr());
                    } else {
                        System.out.println("Error: " + statusResponse.getMessage());
                    }
                } else {
                    System.out.println("Request failed: " + response.message());
                }
            }
        });
    }
}

class StatusRequest {
    private String user_token;
    private String order_id;

    public StatusRequest(String user_token, String order_id) {
        this.user_token = user_token;
        this.order_id = order_id;
    }
}

class StatusResponse {
    private String status;
    private Result result;

    public String getStatus() {
        return status;
    }

    public Result getResult() {
        return result;
    }

    class Result {
        private String txnStatus;
        private String orderId;
        private String amount;
        private String date;
        private String utr;

        public String getTxnStatus() {
            return txnStatus;
        }

        public String getOrderId() {
            return orderId;
        }

        public String getAmount() {
            return amount;
        }

        public String getDate() {
            return date;
        }

        public String getUtr() {
            return utr;
        }
    }
}
