require 'sinatra'
require 'json'

post '/webhook' do
  request.body.rewind
  data = URI.decode_www_form(request.body.read).to_h
  
  status = data['status']
  order_id = data['order_id']
  remark1 = data['remark1']

  # Log webhook data
  File.open('webhook_log.txt', 'a') { |f| f.puts data.to_json }

  # Process webhook data
  if status == "SUCCESS"
    update_transaction_status(order_id, "SUCCESS", remark1)
    "Transaction successful for Order ID: #{order_id}"
  elsif status == "FAILD"
    update_transaction_status(order_id, "FAILED", remark1)
    "Transaction failed for Order ID: #{order_id}"
  else
    status 400
    "Invalid status received"
  end
end

def update_transaction_status(order_id, status, remark)
  puts "Updating transaction #{order_id} to #{status} with remark: #{remark}"
end

# Start Sinatra server
# Run with `ruby webhook.rb` and visit http://localhost:4567/webhook
