<?php
// Set the response header to indicate this is a JSON response
header("Content-Type: application/x-www-form-urlencoded");

// Capture the incoming POST data (IMB sends as x-www-form-urlencoded)
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Get the POST data
    $status = $_POST['status'] ?? null;
    $order_id = $_POST['order_id'] ?? null;
    $remark1 = $_POST['remark1'] ?? null;

    // Optional: Log the data to a file for debugging
    file_put_contents('webhook_log.txt', print_r($_POST, true), FILE_APPEND);

    // Process the webhook data (update the database, perform further actions)
    if ($status === "SUCCESS") {
        // Update transaction as successful in your database
        // Example:
        // updateTransactionStatus($order_id, 'SUCCESS', $remark1);
        echo "Transaction successfully updated for Order ID: " . $order_id;
    } elseif ($status === "FAILD") {
        // Update transaction as failed in your database
        // updateTransactionStatus($order_id, 'FAILED', $remark1);
        echo "Transaction failed for Order ID: " . $order_id;
    } else {
        echo "Invalid status received";
    }
} else {
    echo "Invalid request method";
}

// Function to update the transaction status (You will need to implement this)
function updateTransactionStatus($orderId, $status, $remark) {
    // Add your database connection and query to update transaction status
    // Example using PDO:
    /*
    $db = new PDO('mysql:host=localhost;dbname=yourdb', 'username', 'password');
    $stmt = $db->prepare("UPDATE transactions SET status = :status, remark = :remark WHERE order_id = :order_id");
    $stmt->execute([
        'status' => $status,
        'remark' => $remark,
        'order_id' => $orderId
    ]);
    */
}

?>