<?php
if (file_exists('../pages/dbInfo.php')) {
    include('../pages/dbInfo.php');
    if (defined('DB_HOST') && DB_HOST != '') {
        $warning = "System appears to be already installed. Proceed with caution as this will overwrite your configuration.";
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Application Installer</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        body { background-color: #f8f9fa; font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif; }
        .installer-container { max-width: 800px; margin: 50px auto; background: #fff; border-radius: 10px; box-shadow: 0 0 20px rgba(0,0,0,0.1); overflow: hidden; }
        .installer-header { background: #0c254c; color: #fff; padding: 20px; text-align: center; }
        .installer-body { padding: 30px; }
        .step-indicator { display: flex; justify-content: space-between; margin-bottom: 30px; position: relative; }
        .step-indicator::before { content: ''; position: absolute; top: 15px; left: 0; right: 0; height: 2px; background: #e9ecef; z-index: 0; }
        .step { position: relative; z-index: 1; background: #fff; padding: 0 10px; font-weight: 600; color: #6c757d; }
        .step.active { color: #0c254c; font-weight: bold; }
        .step-icon { width: 30px; height: 30px; background: #e9ecef; border-radius: 50%; display: inline-flex; align-items: center; justify-content: center; margin-right: 5px; color: #fff; }
        .step.active .step-icon { background: #0c254c; }
        .step.completed .step-icon { background: #28a745; }
        .hidden { display: none; }
    </style>
</head>
<body>

<div class="installer-container">
    <div class="installer-header">
        <h3><i class="fas fa-cogs"></i> System Installer</h3>
        <p class="mb-0">Setup your application in a few easy steps</p>
    </div>
    
    <div class="installer-body">
        
        <?php if(isset($warning)): ?>
        <div class="alert alert-danger">
            <i class="fas fa-exclamation-triangle"></i> <b>Warning:</b> <?= $warning ?>
        </div>
        <?php endif; ?>

        <!-- Steps Indicator -->
        <div class="step-indicator">
            <div class="step active" id="step1-indicator"><span class="step-icon">1</span> Database</div>
            <div class="step" id="step2-indicator"><span class="step-icon">2</span> Import SQL</div>
            <div class="step" id="step3-indicator"><span class="step-icon">3</span> Admin Setup</div>
            <div class="step" id="step4-indicator"><span class="step-icon">4</span> Finish</div>
        </div>

        <!-- Step 1: Database Configuration -->
        <div id="step1" class="step-content">
            <h4 class="mb-3">Database Configuration</h4>
            <div class="alert alert-info small"><i class="fas fa-info-circle"></i> Enter your database connection details. These will be saved to <code>pages/dbInfo.php</code>.</div>
            <form id="dbForm">
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Database Host</label>
                        <input type="text" class="form-control" name="host" value="localhost" required>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Database Name</label>
                        <input type="text" class="form-control" name="dbname" required>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Username</label>
                        <input type="text" class="form-control" name="username" required>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Password</label>
                        <input type="text" class="form-control" name="password">
                    </div>
                </div>
                <div class="text-end">
                    <button type="submit" class="btn btn-primary">Check Connection & Continue <i class="fas fa-arrow-right"></i></button>
                </div>
            </form>
        </div>

        <!-- Step 2: Import SQL -->
        <div id="step2" class="step-content hidden">
            <h4 class="mb-3">Import Database</h4>
            <div class="alert alert-warning small"><i class="fas fa-exclamation-triangle"></i> This will overwrite any existing tables in the selected database.</div>
            
            <div class="card p-4 text-center">
                <div id="import-status">
                    <p>Ready to import database schema and default data.</p>
                    <button id="startImportBtn" class="btn btn-success btn-lg"><i class="fas fa-file-import"></i> Run Auto Installer</button>
                </div>
                <div id="import-progress" class="hidden">
                    <div class="spinner-border text-primary mb-2" role="status"></div>
                    <p class="mb-0">Importing SQL... Please wait...</p>
                </div>
            </div>
        </div>

        <!-- Step 3: Admin Setup -->
        <div id="step3" class="step-content hidden">
            <h4 class="mb-3">Create Admin Account</h4>
            <p class="text-muted">Set up your super admin credentials.</p>
            <form id="adminForm">
                <div class="mb-3">
                    <label class="form-label">Full Name</label>
                    <input type="text" class="form-control" name="admin_name" required>
                </div>
                <div class="mb-3">
                    <label class="form-label">Mobile Number (Login ID)</label>
                    <input type="number" class="form-control" name="admin_mobile" required>
                </div>
                <div class="mb-3">
                    <label class="form-label">Email Address</label>
                    <input type="email" class="form-control" name="admin_email" required>
                </div>
                <div class="mb-3">
                    <label class="form-label">Password</label>
                    <input type="password" class="form-control" name="admin_password" required>
                </div>
                <div class="text-end">
                     <button type="submit" class="btn btn-primary">Create Admin & Finish <i class="fas fa-check"></i></button>
                </div>
            </form>
        </div>

        <!-- Step 4: Finish -->
        <div id="step4" class="step-content hidden text-center">
            <div class="text-success mb-3">
                <i class="fas fa-check-circle fa-5x"></i>
            </div>
            <h3>Installation Successful!</h3>
            <p>Your application has been successfully installed.</p>
            <div class="alert alert-danger mt-4">
                <i class="fas fa-lock"></i> <b>Security Warning:</b> Please delete the <code>install</code> folder from your server.
            </div>
            <a href="../admin" class="btn btn-primary btn-lg mt-3">Go to Admin Panel</a>
        </div>

    </div>
</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
    function nextStep(current, next) {
        $('#'+current).addClass('hidden');
        $('#'+next).removeClass('hidden');
        $('#'+current+'-indicator').addClass('completed').removeClass('active');
        $('#'+next+'-indicator').addClass('active');
    }

    // Step 1: DB Config
    $('#dbForm').on('submit', function(e){
        e.preventDefault();
        const btn = $(this).find('button');
        const originalText = btn.html();
        btn.html('<i class="fas fa-spinner fa-spin"></i> Connecting...').prop('disabled', true);

        $.ajax({
            url: 'process.php',
            type: 'POST',
            data: $(this).serialize() + '&action=check_db',
            dataType: 'json',
            success: function(res) {
                if(res.status === 'success') {
                    nextStep('step1', 'step2');
                } else {
                    Swal.fire('Error', res.message, 'error');
                }
            },
            error: function() {
                Swal.fire('Error', 'Server error occurred', 'error');
            },
            complete: function() {
                btn.html(originalText).prop('disabled', false);
            }
        });
    });

    // Step 2: Import SQL
    $('#startImportBtn').on('click', function(){
        $('#import-status').addClass('hidden');
        $('#import-progress').removeClass('hidden');

        $.ajax({
            url: 'process.php',
            type: 'POST',
            data: { action: 'import_sql' },
            dataType: 'json',
            success: function(res) {
                if(res.status === 'success') {
                    nextStep('step2', 'step3');
                } else {
                    Swal.fire('Error', res.message, 'error');
                    $('#import-status').removeClass('hidden');
                    $('#import-progress').addClass('hidden');
                }
            },
            error: function() {
                Swal.fire('Error', 'Import failed due to server error', 'error');
                $('#import-status').removeClass('hidden');
                $('#import-progress').addClass('hidden');
            }
        });
    });

    // Step 3: Admin Setup
    $('#adminForm').on('submit', function(e){
        e.preventDefault();
        const btn = $(this).find('button');
        btn.prop('disabled', true);

        $.ajax({
            url: 'process.php',
            type: 'POST',
            data: $(this).serialize() + '&action=create_admin',
            dataType: 'json',
            success: function(res) {
                if(res.status === 'success') {
                    nextStep('step3', 'step4');
                } else {
                    Swal.fire('Error', res.message, 'error');
                    btn.prop('disabled', false);
                }
            },
            error: function() {
                Swal.fire('Error', 'Server error', 'error');
                btn.prop('disabled', false);
            }
        });
    });
</script>

</body>
</html>
