<?php
error_reporting(0);
session_start();

$action = isset($_POST['action']) ? $_POST['action'] : '';

header('Content-Type: application/json');

function sendResponse($status, $message, $data = []) {
    echo json_encode(['status' => $status, 'message' => $message, 'data' => $data]);
    exit;
}

if ($action == 'check_db') {
    $host = $_POST['host'];
    $dbname = $_POST['dbname'];
    $username = $_POST['username'];
    $password = $_POST['password'];

    // 1. Test Connection
    try {
        $mysqli = new mysqli($host, $username, $password, $dbname);
        if ($mysqli->connect_error) {
            sendResponse('error', 'Connection failed: ' . $mysqli->connect_error);
        }
    } catch (Exception $e) {
        sendResponse('error', 'Connection Exception: ' . $e->getMessage());
    }

    // 2. Write to pages/dbInfo.php
    $configFileContent = '<?php
error_reporting(0);
date_default_timezone_set("Asia/Kolkata");

function connect_database() {
	$dbHost = "' . $host . '";
	$dbLogin = "' . $username . '";
	$dbPwd = "' . $password . '";
	$dbName = "' . $dbname . '";
	$con = mysqli_connect($dbHost, $dbLogin, $dbPwd, $dbName);
	if (!$con) {
		die("Database Connection failed: " . mysqli_connect_errno());
	}
	return ($con);
}

// Database configuration
define("ADMIN_TOKEN", "' . md5(uniqid(rand(), true)) . '");
define("DB_HOST", "' . $host . '");
define("DB_USERNAME", "' . $username . '");
define("DB_PASSWORD", "' . $password . '");
define("DB_NAME", "' . $dbname . '");
?>';

    $configPath = '../pages/dbInfo.php';
    if (file_put_contents($configPath, $configFileContent)) {
        $_SESSION['db_host'] = $host;
        $_SESSION['db_user'] = $username;
        $_SESSION['db_pass'] = $password;
        $_SESSION['db_name'] = $dbname;
        sendResponse('success', 'Database connected and config saved.');
    } else {
        sendResponse('error', 'Could not write to pages/dbInfo.php. Check permissions.');
    }
}

if ($action == 'import_sql') {
    if (!isset($_SESSION['db_host'])) {
        sendResponse('error', 'Session expired. Please restart.');
    }

    $mysqli = new mysqli($_SESSION['db_host'], $_SESSION['db_user'], $_SESSION['db_pass'], $_SESSION['db_name']);
    
    $sqlFile = 'sql/database.sql';
    if (!file_exists($sqlFile)) {
        sendResponse('error', 'SQL file not found.');
    }

    $query = file_get_contents($sqlFile);
    
    // Split SQL by semicolon
    $mysqli->multi_query($query);
    
    while ($mysqli->next_result()) {;} // flush multi_queries

    if ($mysqli->errno) {
         sendResponse('error', 'SQL Error: ' . $mysqli->error);
    }

    sendResponse('success', 'Database imported successfully.');
}

if ($action == 'create_admin') {
    if (!isset($_SESSION['db_host'])) {
        sendResponse('error', 'Session expired.');
    }

    $mysqli = new mysqli($_SESSION['db_host'], $_SESSION['db_user'], $_SESSION['db_pass'], $_SESSION['db_name']);

    $name = $mysqli->real_escape_string($_POST['admin_name']);
    $mobile = $mysqli->real_escape_string($_POST['admin_mobile']);
    $email = $mysqli->real_escape_string($_POST['admin_email']);
    $password = password_hash($_POST['admin_password'], PASSWORD_DEFAULT);
    
    // Default values for other columns
    $token = md5(uniqid());

    // Check if table exists (in case import failed or was skipped)
    $checkTable = $mysqli->query("SHOW TABLES LIKE 'users'");
    if($checkTable->num_rows == 0) {
         sendResponse('error', 'Users table not found. Did the SQL import work?');
    }

    $sql = "INSERT INTO users (name, mobile, email, password, role, pin, token, active, acc_ban, acc_lock) 
            VALUES ('$name', '$mobile', '$email', '$password', 'Admin', '0000', '$token', '1', '0', '0')";

    if ($mysqli->query($sql)) {
        sendResponse('success', 'Admin created successfully.');
    } else {
        sendResponse('error', 'Error creating admin: ' . $mysqli->error);
    }
}
?>
